var Sizer = new (function(){
	var key = null;
	var size = 0;
	var count = 0;

	this.help = function(){
		showMessage('<html>Sizer - adds user menu to create tree and display total file size and popup menu to display node/file sizes.');
	}

	addUserCommand('sizer', function(){
		Sizer.help();
	}, 'Help');

	addUserCommand('File System', function(){
		doIt(false);
	}, 'Sizer');

	addUserCommand('Database', function(){
		doIt(true);
	}, 'Sizer');
	
	function doIt(isCat){
		size = 0;
		count = 0;
                key = addTreeFilter('Directory,FileName', 'Sizer.match(Directory,FileName)');
                var f = function(){
                        removeTreeFilter(key);
                        key = null;
			showSize();
                };
                buildTree(isCat, f);

	}

        this.match = function(dir,file){
		var f = new java.io.File(dir, file);
		if(f.exists()){
			count++;
			size += f.length();
		}
		return true;
        }

	addMenuCommand("File Size", function(nodes){
		size = 0;
		count = 0;
		var f = function(){
        	//for each(var node in nodes){
		for(var i = 0; i < nodes.length; i++){
			var node = nodes[i];
			var f = new java.io.File(node.dir, node.name);
			if(f.exists()){
				count++;
				size += f.length();
			}
        	}
		}
		background(f, function(){showSize();});
	});

	function showSize(){
        	var mb = size / 1000000;
                var gb = size / 1000000000;
                showMessage('<html>' + count + ' files<br><br>' + format(mb) + ' megabytes<br>' + format(gb) + ' gigabytes<br><br>');
	}

	function format(n){
		return java.text.NumberFormat.getInstance().format(n);
	}

})();
