// Psych
// creates a random "psychelic" painter. Adds menu options for buffered and unbuffered painting.
// Buffered painting requires the BufferedPainter function in util.js


var Psych = new (function(){
	var painterId = 'Psych';

	this.paintMain = function(b, buffered){
		if(b){
			var p = buffered ? new BufferedPainter(Psych.getPainter()) : Psych.getPainter();
			setPainter(p);

		}else{
			setPainter(null, painterId);
		}
		
	}

	this.paintThumbnails = function(b){
		if(b){
			setThumbnailPainter(Psych.getPainter());
		}else{
			setThumbnailPainter(null);
		}
	}



	this.help = function(){
		showMessage('<html>Psych<br>Psychedlic filter that changes on every repaint.<br><li>paintMain(boolean)<li>paintThumbnails(boolean)<li>getPainter()');
	}

	addUserCommand('psych', function(){
		Psych.help();
	}, 'Help');

	
	// jump through hoops for rhino
	function getRGB(r, g, b, a){
		var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8)  | ((b & 0xFF) << 0);
		return new java.awt.Color(val, true);		
	}
	
	
	function rc(){
		var r = Math.floor((Math.random() * 255) + 0);
		var g = Math.floor((Math.random() * 255) + 0);
		var b = Math.floor((Math.random() * 255) + 0);
		//return new java.awt.Color(r,g,b);
		//do this to remain compatible with rhino with rhino/nashorn specific syntax
		return getRGB(r,g,b,255);
	}
	
	var painter = function(gfx, image, ig, pp){
	
		if(image != null){

			var rect = pp.getImageRect(image);
			var x = rect.x;
			var y = rect.y;
			var vw = rect.width;
			var vh = rect.height;
	
			gfx.translate(Math.max(pp.imageX, 0), Math.max(pp.imageY, 0));
			var c1 = rc();
			var c2 = rc();
			var c3 = rc();
			var c4 = rc();
			var c5 = rc();
			for(var i = x; i < vw + x; i++){
				for(var j = y; j < vh + y; j++){
	
					var pixel = image.getRGB(i,j);
	
					var b = (pixel) & 0xff;
					var g = (pixel >> 8) & 0xff;
					var r = (pixel >> 16) & 0xff;
					
					// draw highlights
					
					if(r > 200 && g > 200 && b > 200){
						gfx.setColor(c1);
						gfx.drawLine(i - x, j - y, i - x, j - y);
					}else if(r > 150 && g > 150 && b > 150){
						gfx.setColor(c2);
						gfx.drawLine(i - x, j - y, i - x, j - y);
					}else if(r < 55 && g < 55 && b < 55){
						gfx.setColor(c3);
						gfx.drawLine(i - x, j - y, i - x, j - y);
							
					}else if(r < 105 && g < 105 && b < 105){
						gfx.setColor(c4);
						gfx.drawLine(i - x, j - y, i - x, j - y);
					}else{
						gfx.setColor(c5);
						gfx.drawLine(i - x, j - y, i - x, j - y);
					}	
					
				}
			}
	
	
		}
	};
	
	this.getPainter = function(){

		return JSI.namedPainter(painter, painterId);
	}

	addUserCommand('Buffered', function(){
		Psych.paintMain(true, true);

	}, 'Psych');

	addUserCommand('Unbuffered', function(){
		Psych.paintMain(true, false);

	}, 'Psych');
/*
	var linkerExists = null;
	
	function linkerCheck(){
		if(linkerExists == null){
			linkerExists = false;
			try{	
				var p = PAINTERLINKER;
				linkerExists = true;
			}catch(e){}
		}
	}
*/
})();



