var Previewer = new(function() {

    // jump through hoops for rhino
    function getRGB(r, g, b, a) {
        var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | ((b & 0xFF) << 0);
        return new java.awt.Color(val, true);

    }

    var JH = com.jhlabs.image;

    // default list of tags to display
    var tags = ["FileName", "Model", "JpegLensModel", "Aperture", "FocalLength", "ShutterSpeed", "ISO", "DateTimeOriginal", "ElapsedTime"];

    this.setTags = function(t) {
        tags = t == null ? [] : t;
    }

    this.addTag = function(t) {
        tags[tags.length] = t;
    }

    var bgFilter = new JH.GaussianFilter();
    bgFilter.radius = 10;
    var bgPainter = {};
    bgPainter.paint = function(gfx, image, img, pp) {
        bgFilter.filter(image, image);
    }


    this.setPainter = function(p) {
        if (typeof p === 'function') {
            bgPainter = {};
            bgPainter.paint = p;
        } else {
            bgPainter = p;
        }

    }

    var textColor = java.awt.Color.WHITE;
    this.setTextColor = function(r, g, b) {
        //textColor = new java.awt.Color(r,g,b);
        textColor = getRGB(r, g, b, 0);
    }

    this.help = function() {
        showMessage('<html>Previewer<br>Display stylized rollover image with selected tags.<br><li>setPainter(painter)<li>setTextColor(int,int,int)<li>setTags(string[])<li>addTag(string)');
    }

    addUserCommand('previewer', function() {
        Previewer.help();
    }, 'Help');

    // create a painter for a stylized preview image showing meta data
    function createPainter() {

        var painter = function(gfx, image, img, pp) {
            if (image != null && !pp.dragging && !pp.zooming) {
                gfx.setFont(new java.awt.Font("SanSerif", java.awt.Font.PLAIN, 20));
                var r = pp.getImageRect(image);

                var subimage = image;

                if (bgPainter != null)
                    bgPainter.paint(gfx, image, img, pp);

                gfx.drawImage(subimage, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);

                var ex = getExifData(pp.dir, pp.file);
                var lineY = 25;
                var found = 0;
                var fa = new Array();
                gfx.setRenderingHint(java.awt.RenderingHints.KEY_TEXT_ANTIALIASING, java.awt.RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                var idx = 0;
                for (var i = 0; i < ex.length; i++) {
                    for (var j = 0; j < tags.length; j++) {
                        if (ex[i].indexOf(tags[j] + ':') == 0) {

                            fa[idx++] = ex[i];
                            found++;
                            break;
                        }

                    }
                    if (found == tags.length) {
                        break;
                    }
                }

                gfx.setColor(java.awt.Color.black);
                for (var i = 0; i < fa.length; i++) {
                    // use Java Integer because of error if using @nashornopts -pcc		
                    gfx.drawString(fa[i], 11, new java.lang.Integer(lineY + 1));
                    lineY += 25;

                }
                lineY = 25;
                gfx.setColor(textColor);
                for (var i = 0; i < fa.length; i++) {
                    // use Java Integer because of error if using @nashornopts -pcc
                    gfx.drawString(fa[i], 10, new java.lang.Integer(lineY));
                    lineY += 25;


                }
            }
        };

        setPreviewPainter(painter);

    }

    // set the preview painter
    createPainter();
})();
