var JHLabs = new(function() {

    var rhino = script_engine_name === 'rhino';
    var nashorn = script_engine_name === 'nashorn';
    var graal = script_engine_name == 'graal.js';

    var JH = com.jhlabs.image;

    if (rhino || nashorn) {
        try {
            // required for sync when using nashorn
            load("nashorn:mozilla_compat.js");
        } catch (ex) {}
    }
    

    // array of JHLabs filters to add to top-level user menu	
    var filters = [{
            name: "Custom",
            f: function(m, s) {

                var cb = function(filterReq) {
                    if(filterReq != null){		
                        var painter = JHLabs.getPainter(filterReq);
                        setFilterPainter(painter, s);
                    }
                }

                request("Enter filter names separated by spaces", cb);

            }
        },
        {
            name: "Stamp",
            f: function(m, s) {
                createFilterPainter(new JH.StampFilter(), s);
            }
        },
        {
            name: "Crystallize",
            f: function(m, s) {
                createFilterPainter(new JH.CrystallizeFilter(), s);
            }
        },
        {
            name: "Solarize",
            f: function(m, s) {
                createFilterPainter(new JH.SolarizeFilter(), s);
            }
        },
        {
            name: "Emboss",
            f: function(m, s) {
                createFilterPainter(new JH.EmbossFilter(), s);
            }
        },
        {
            name: "Kaleidoscope",
            f: function(m, s) {
                createFilterPainter(new JH.KaleidoscopeFilter(), s);
            }
        },
        {
            name: "Laplace",
            f: function(m, s) {
                createFilterPainter(new JH.LaplaceFilter(), s);
            }
        },
        {
            name: "Edge",
            f: function(m, s) {
                createFilterPainter(new JH.EdgeFilter(), s);
            }
        },
        {
            name: "Marble",
            f: function(m, s) {
                createFilterPainter(new JH.MarbleFilter(), s);
            }
        },
        {
            name: "Glow",
            f: function(m, s) {
                createFilterPainter(new JH.GlowFilter(), s);
            }
        },
        {
            name: "Bump",
            f: function(m, s) {
                createFilterPainter(new JH.BumpFilter(), s);
            }
        },
        {
            name: "ColorHalftone",
            f: function(m, s) {
                createFilterPainter(new JH.ColorHalftoneFilter(), s);
            }
        },
        {
            name: "Plasma",
            f: function(m, s) {
                createFilterPainter(new JH.PlasmaFilter(), s);
            }
        },
        {
            name: "Oil",
            f: function(m, s) {
                createFilterPainter(new JH.OilFilter(), s);
            }
        },
        {
            name: "Grayscale",
            f: function(m, s) {
                createFilterPainter(new JH.GrayscaleFilter(), s);
            }
        },
        {
            name: "Sharpen",
            f: function(m, s) {
                createFilterPainter(new JH.SharpenFilter(), s);
            }
        },
        {
            name: "Pointillize",
            f: function(m, s) {

                var cb = function(levels) {

                    if (levels == null || levels == '') {
                        levels = 16;
                    }
                    var cf = new JH.PointillizeFilter();
                    cf.setScale(parseInt(levels, 10));
                    createFilterPainter(cf, s);
                }
                request("Enter Scale", cb);

            }
        },
        {
            name: "Posterize",
            f: function(m, s) {
                var cb = function(levels) {
                    if (levels == null || levels == '') {
                        levels = 256;
                    }
                    var cf = new JH.PosterizeFilter();
                    cf.setNumLevels(parseInt(levels, 10));
                    createFilterPainter(cf, s);
                }

                request("Enter Number Of Levels", cb);

            }
        },
        {
            name: "Gaussian",
            f: function(m, s) {
                var cb = function(radius) {
                    if (radius == null || radius == '') {
                        radius = 0;
                    }

                    var cf = new JH.GaussianFilter();
                    cf.setRadius(parseInt(radius, 10));

                    createFilterPainter(cf, s);
                }

                request("Enter Radius", cb);

            }
        },
        {
            name: "Quantize/Dither",
            f: function(m, s) {
                var cb = function(colors) {
                    if (colors == null || colors == '') {
                        colors = 8;
                    }

                    var cf = new JH.QuantizeFilter();
                    cf.setNumColors(parseInt(colors, 10));
		    cf.setDither(true);
                    createFilterPainter(cf, s);
                }

                request("Enter Number Of Colors", cb);

            }
        },
        {
            name: "Compound",
            f: function(m, s) {
                var filter1 = new JH.GrayscaleFilter();
                var filter2 = new JH.SolarizeFilter();
                var compoundFilter = new JH.CompoundFilter(filter1, filter2);
                createFilterPainter(compoundFilter, s);
            }
        },
        {
            name: "Random",
            f: function(m, s) {
                createRandomPainter(s);
            }
        }

    ];

    // create painter based on jhlabs filter name - can create a combined filter with custom settings
    // see the help function for details
    this.getPainter = function(filterReq) {

        var painter = null;

        var fa = filterReq.split(" ");

        var allFilters = new Array();
	var name = '';
        for (var i = 0; i < fa.length; i++) {

            allFilters[allFilters.length] = createFilterFromString(fa[i]);
	    name += allFilters[i].toString();
	    if(i < fa.length - 1){
		name += ':';
	    }
        }

        if (fa.length == 1) {
            painter = makePainter(allFilters[0], allFilters[0].toString());
        } else {
            var compoundFilters = new Array();
            for (var i = 0; i < allFilters.length; i += 2) {
                if (i + 1 < allFilters.length) {
                    if (i == 0) {
                        compoundFilters[compoundFilters.length] = new JH.CompoundFilter(allFilters[i], allFilters[i + 1]);
                    } else {
                        compoundFilters[compoundFilters.length] = new JH.CompoundFilter(compoundFilters[compoundFilters.length - 1], allFilters[i]);
                        compoundFilters[compoundFilters.length] = new JH.CompoundFilter(compoundFilters[compoundFilters.length - 1], allFilters[i + 1]);
                    }
                } else {
                    compoundFilters[compoundFilters.length] = new JH.CompoundFilter(compoundFilters[compoundFilters.length - 1], allFilters[i]);

                }
            }

            painter = makePainter(compoundFilters[compoundFilters.length - 1], name);
        }

        return painter;

    }

    function createRandomPainter(submenu) {


        var p = function(gfx, image, img, pp) {

            var r = pp.getImageRect(image);
            var subimage = image.getSubimage(r.x, r.y, r.width, r.height);
            var destImage = new java.awt.image.BufferedImage(r.width, r.height, java.awt.image.BufferedImage.TYPE_INT_ARGB);

            // JHLabs filters are not thread safe and we're doing thumbnails
            var func = function() {
                var filterList = [JH.SolarizeFilter, JH.KaleidoscopeFilter, JH.EdgeFilter, JH.SolarizeFilter,
                    JH.ColorHalftoneFilter, JH.EmbossFilter, JH.GrayscaleFilter, JH.OilFilter, JH.BumpFilter,
                    JH.LaplaceFilter, JH.MarbleFilter
                ];

                var idx = Math.floor((Math.random() * filterList.length) + 0);

                var filter = new filterList[idx]();
                var ci = filter.filter(subimage, destImage);
                gfx.drawImage(ci, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);
                //_super_.setCacheObject(ci, pp);	
            }
            if (rhino || nashorn) {
                sync(func)();
            } else {
                func();
            }



        };

        var cpainter = p;
        //var cpainter = new BufferedPainter(p);
        if (submenu === 'Filters') {
            setPainter(cpainter, 'JHLabs:Random');
        } else {
            setThumbnailPainter(cpainter);

        }

    }

    // create a PhotoGrok compatible painter using the passed in filter

    function createFilterPainter(filter, submenu) {

        var cpainter = makePainter(filter, filter.toString());
        setFilterPainter(cpainter, submenu);

    }

    function setFilterPainter(painter, submenu) {
        // preserve the current filters if script gets compiled
        if (submenu === 'Filters') {
            setPainter(new BufferedPainter(painter));
        } else {
            setThumbnailPainter(new BufferedPainter(painter));
        }
    }

    function makePainter(filter, name) {
        var p = function(gfx, image, img, pp) {


            var r = pp.getImageRect(image);
            var subimage = image.getSubimage(r.x, r.y, r.width, r.height);
            var destImage = new java.awt.image.BufferedImage(r.width, r.height, java.awt.image.BufferedImage.TYPE_INT_ARGB);

            // JHLabs filters are not thread safe and we're potentially doing thumbnails

            var func = function() {
                var ci = filter.filter(subimage, destImage);
                gfx.drawImage(ci, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);

            }
            if (nashorn || rhino) {
                sync(func)();
            } else {
                // graal.js doesn't support sync so painter function is syncrhonized
                // within photogrok
                func();
            }


        };

        return JSI.namedPainter(p, 'JHLabs:' + name);
    }

    // add a top-level "User" menu to set main image filter

    for (var i = 0; i < filters.length; i++) {
        addUserCommand(filters[i].name, filters[i].f, "Filters");
    }

    // add a top-level "User" menu to set thumbnail filters
    for (var i = 0; i < filters.length; i++) {
        addUserCommand(filters[i].name, filters[i].f, "Thumbnail Filters");
    }

    function createFilterFromString(f) {

        var aarray = f.split(":");
        if (aarray.length == 1) {
            return eval("new JH." + f + "Filter()");
        } else {

            var newFilter = eval("new JH." + aarray[0] + "Filter()");

            for (var i = 1; i < aarray.length; i++) {

		if(graal){
			// emulate rhino and nashorn
			var arg = aarray[i].substring(aarray[i].indexOf('=') + 1);
			var func = aarray[i].substring(0, aarray[i].indexOf('='));
			var funcCap = func.charAt(0).toUpperCase() + func.slice(1)
			eval("newFilter.set" + funcCap + '(' + arg + ')');

		}else{
                	eval("newFilter." + aarray[i]);
		}

            }
            return newFilter;
        }


        return newFilter;
    }


    this.help = function() {
        var help = '<html>JHLabs<br>Create user menus to set a JHLabs filter for thumbnails or main images.<br>' +
            'See: http://www.jhlabs.com/ip/filters/ and https://github.com/ajmas/JH-Labs-Java-Image-Filters<br><br>' +
            'The "Custom" option creates dynamic filters from a prompted string.<br>Filters are separated by a space. Parameters can be added with a colon.<br><br>' +
            '<b>Crystallize Emboss</b> : combines the Crystallize and Emboss filters.<br>' +
            '<b>Gaussian:radius=10</b> : creates a Gaussian filter with radius set to 10.<br>' +
            '<b>Grayscale Gaussian:radius=20</b> : combine Grayscale with radius 20 Gaussian filter.' +
            '<br><br>Functions:<li>getPainter(filtername)';
        showMessage(help);
    }

    addUserCommand('jhlabs', function() {
        JHLabs.help();
    }, 'Help');



})();
