var Histogram = new(function() {

    var painterId = 'Histogram';
    var savePainter;

    var isOn = false;
    this.help = function() {
        showMessage('<html>Histogram<br>Toggle dynamic histogram.<br><li>showHighlights(boolean)</li><li>showShadows(boolean)</li><li>on()</li><li>off()</li><li>getPainter()</li></li>');
    }

    addUserCommand('histogram', function() {
        Histogram.help();
    }, 'Help');

    // syntax for rhino compatibility or nashorn without optimistic typing
    var red = getRGB(255, 0, 0, 100);
    var green = getRGB(0, 255, 0, 100);
    var blue = getRGB(0, 0, 255, 100);


    var max = 0;

    var rvals, gvals, bvals;
 
    var highlights = false;
    var shadows = false;

    this.showHighlights = function(b) {
        highlights = b;
    }

    this.showShadows = function(b) {
        shadows = b;
    }

    this.on = function() {

        var cp = JSI.getPainter();

	if(UTIL.pID(JSI.getPainter()).indexOf(painterId) == -1){

	    savePainter = cp;

	    if (cp != null && cp.getName().indexOf('Filler') == -1 && cp.getName().indexOf('LINKED') == -1) // Filler does not work with ComboPainter
		setPainter(new BufferedPainter(new ComboPainter(cp, Histogram.getPainter())));
	    else
		setPainter(new BufferedPainter(Histogram.getPainter()));

	    isOn = true;

	}

	
    }

    this.off = function() {

	if(UTIL.pID(JSI.getPainter()).indexOf(painterId) != -1){
		if(savePainter != null && savePainter.getName().indexOf('LINKED') != -1){
			setPainter(null, painterId);
		}else{
        		setPainter(savePainter);
			savePainter = null;
		}
        	isOn = false;

	}

    }

    // jump through hoops for rhino
    function getRGB(r, g, b, a) {
        var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | ((b & 0xFF) << 0);
        return new java.awt.Color(val, true);

    }

    this.getPainter = function() {
        return JSI.namedPainter(painter, painterId);
    }

    function getMax(array) {
        val = array[0];
        for (var i = 0; i < array.length; i++) {
            if (array[i] > val) {
                val = array[i];
            }
        }
        return val;

    }
    // register a painter function

    var painter = function(gfx, image, ig, pp) {

        if (image != null) {
            var rect = pp.getImageRect(image);
            var img = image.getSubimage(rect.x, rect.y, rect.width, rect.height);

            // create typed arrays to hold image data

            rvals = new Int16Array(256);
            gvals = new Int16Array(256);
            bvals = new Int16Array(256);

            for (var i = 0; i < img.getWidth(); i++) {
                for (var j = 0; j < img.getHeight(); j++) {

                    var pixel = img.getRGB(i, j);

                    var b = (pixel) & 0xff;
                    var g = (pixel >> 8) & 0xff;
                    var r = (pixel >> 16) & 0xff;

                    rvals[r]++;
                    gvals[g]++;
                    bvals[b]++;

                    if (highlights) {

                        // draw highlights

                        if (r > 250 && g > 250 && b > 250) {
                            gfx.setColor(java.awt.Color.RED);
                            gfx.drawLine(i + Math.max(0, pp.imageX), j + Math.max(0, pp.imageY), i + Math.max(0, pp.imageX), j + Math.max(0, pp.imageY));

                        }
                    }


                    if (shadows) {

                        // draw shadows

                        if (r < 5 && g < 5 && b < 5) {
                            gfx.setColor(java.awt.Color.BLUE);
                            gfx.drawLine(i + Math.max(0, pp.imageX), j + Math.max(0, pp.imageY), i + Math.max(0, pp.imageX), j + Math.max(0, pp.imageY));

                        }
                    }
                }
            }

            var redMax = getMax(rvals);
            var gMax = getMax(gvals);
            var bMax = getMax(bvals);
            max = Math.max(redMax, gMax, bMax);

            // draw histogram box

            gfx.setColor(java.awt.Color.YELLOW);

            var offX = 10;
            gfx.drawRect(offX, 6, 258, 102);

            // draw histogram

            histogram(gfx, red, rvals, offX, 6, max);
            histogram(gfx, green, gvals, offX, 6, max);
            histogram(gfx, blue, bvals, offX, 6, max);
        }
    };



    function histogram(gfx, color, vals, offX, offY, max) {

        gfx.setColor(color);

        for (var c = 0; c < 256; c++) {
            var pct = (vals[c] / max) * 100;
            var pt = 101 - Math.round(pct);
            gfx.drawRect(c + 1 + offX, offY + pt, 1, Math.round(pct));

        }
    }

    var painterChanged = function(pId, isNull, p) {

	if(pId != null){
		
		isOn = pId.indexOf(painterId) != -1;
	}else{
		isOn = false;
	}
    }

    registerCallback('onPainterChanged', painterChanged);


    addUserCommand('Histogram Toggle', function() {

        	isOn = !isOn
        	isOn ? Histogram.on() : Histogram.off();
	

    });



})();
