var Framer = new(function() {

    var tagMap = null;
    var dataList = null;
    var defaultColor = null;
    var useImageColor = false;

    this.help = function() {
        showMessage('<html>Framer<br>Set color of thumbnail frame based on tag value or predominate color of image.' +
            '<br><li>addTag(tag, value, java.awt.Color)</li>' +
            '<li>setBackgroundColor(java.awt.Color)</li>' +
            '<li>useImageColor(boolean)</li></html>' +
            '\n"value" can be a javascript expression that evaluates to true or false (start with "=" character).\n' +
            '\nExamples:\nFramer.addTag(\'ISO\', 200, java.awt.Color.GREEN);\n' +
            'Framer.addTag(\'Keywords\', \'=Keywords.indexOf(\\\'mykeyword\\\') != -1\', java.awt.Color.BLUE);\n' +
            'Links with other thumbnail painters using thumblink function in util.js.'
        );
    }

    addUserCommand('framer', function() {
        Framer.help();
    }, 'Help');

    this.addTag = function(tag, value, color) {

        if (tagMap == null) {
            tagMap = new java.util.HashMap();
        }
        var ta = tagMap.get(tag);
        if (ta != null) {
            ta[ta.length] = {
                "v": value,
                "color": color
            };
        } else {
            tagMap.put(tag, [{
                "v": value,
                "color": color
            }]);
        }

    }

    var onBuildTree = function(cat) {
        if (tagMap != null) {

            var tagKeys = tagMap.keySet().toArray();

            if (tagKeys.length > 0) {
                var q = 'FileName,Directory,';
                for (var i = 0; i < tagKeys.length; i++) {
                    q += tagKeys[i];
                    if (i < tagKeys.length - 1) {
                        q += ',';
                    }
                }
                addTreeFilter(q, 'Framer.matchTag(' + q + ')');
            }
            dataList = new java.util.HashMap();
        }
        getMap().remove('dataList');
    }

    registerCallback('onBuildTree', onBuildTree);

    this.setBackgroundColor = function(c) {
        defaultColor = c;
    }

    this.useImageColor = function(b) {
        useImageColor = b;
    }

    this.matchTag = function() {

        var fn = arguments[0];
        var dir = arguments[1];

        var tagKeys = tagMap.keySet().toArray();

        outer:
            for (var i = 0; i < tagKeys.length; i++) {

                var ta = tagMap.get(tagKeys[i]); // array of json containing value and color

                for (var j = 0; j < ta.length; j++) {

                    if (ta[j].v.length > 0 && ta[j].v.charAt(0) == '=') {

                        if (eval('var ' + tagKeys[i] + '=\'' + escape(arguments[i + 2]) + '\';' + ta[j].v.substring(1))) {
                            dataList.put(fn + '' + dir, ta[j].color);
                            break outer;
                        }
                    } else
                    if (ta[j].v == arguments[i + 2]) {
                        dataList.put(fn + '' + dir, ta[j].color);
                        break outer;
                    }
                }


            }
        return true;
    }

    var done = function() {
        getMap().put('dataList', dataList);
    }

    registerCallback('done', done);

    var painter = function(gx, image, ig, pp) {

        if (dataList != null) {
            var path = pp.file + '' + pp.dir;

            var d = dataList.get(path);

            if (d != null)
                pp.frameColor = d;
            else
                setDefaultColor(image, pp);

        } else {
            setDefaultColor(image, pp);
        }

    };

    function setDefaultColor(image, pp) {
        if (useImageColor) {
            pp.frameColor = getAverageColor(image).brighter();
        } else {
            pp.frameColor = defaultColor;
        }
    }

    setThumbnailPainter(painter);

    try {
        UTIL.thumbLink(painter);
    } catch (e) {}


    function getAverageColor(image) {
        var width = image.getWidth();
        var height = image.getHeight();
        var sumr = 0,
            sumg = 0,
            sumb = 0;
        for (var x = 0; x < width; x++) {
            for (var y = 0; y < height; y++) {
                var pixel = image.getRGB(x, y);
                sumr += (pixel & (255 << 16)) >> 16;
                sumg += (pixel & (255 << 8)) >> 8;
                sumb += (pixel & 255);
            }
        }
        var numPixels = width * height;

        return getRGB(sumr / numPixels, sumg / numPixels, sumb / numPixels, 255.0);
    }

    // jump through hoops for rhino
    function getRGB(r, g, b, a) {
        var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | ((b & 0xFF) << 0);
        return new java.awt.Color(val, true);

    }


})();
