var FixTime = new (function(){

addMenuCommand("Fix Time", function(nodes){

	var cb = function(offset){

		if(offset == null){
			return;
		}

		if(offset !== '+' && offset !== '-'){
			showMessage('invalid input');
			return;
		}
		//var adjust = request('Enter number of hours');

		var adjCB = function(adjust){
			if(adjust == null){
				return;
			}
			var adj = parseInt(adjust);

			if(isNaN(adj)){
				showMessage('invalid input - not a whole number');
				return;
			}
			if(adj < 0){
				showMessage('invalid input - negative number');
				return;
			}
			// nashorn version when string interpolation on
			//var parm = "-AllDates${offset}=${adj}";

			var parm = "-AllDates" + offset + "=" + adj;
			for(var i = 0; i < nodes.length; i++){
				var node = nodes[i];
				setStatusText("Fixing Time: " + node.name, true);
				var cmd = ['-overwrite_original', parm, node.dir + java.io.File.separator + node.name]; 
				var res = execExifTool(cmd);
				setStatusText("Refreshing: " + node.name, true);
				refreshFile(node.dir, node.name);
			}
			setStatusText(null, false);
		}
		request('Enter number of hours', adjCB);
	}
	request('Enter offset (+ or -)', cb);


});

this.help = function(){
	var help = '<html>FixTime<br>Add a "Fix Time" menu to offset all timestamps in selected images in hour increments.<br>'
			+ 'Prompts for offset and number of hours. Use to fix DST or timezone issues.<br><br>'
			+ 'Please make sure images are backed up before editing. See ExifTool documentation.';
	showMessage(help);	
}

addUserCommand('fixtime', function(){
	FixTime.help();
}, 'Help');


})();
