// Film simulations - algorithms written by chatGPT

var Film = new(function() {

    var cArray = ['Velvia', 'Classic Negative', 'Eterna', 'Eterna Beach Bypass', 'Classic Chrome', 'Acros', 'Sepia'];

    this.help = function() {
        showMessage('<html>Film Filters<br>Algorithms by ChatGPT<br><li>getPainter(int)</li></html>Argument is an integer 0 through 8. See "Film" in "User" menu for corresponding filter name.');
    }

    addUserCommand('film', function() {
        Film.help();
    }, 'Help');


    this.getPainter = function(imgType) {

        function applyFujiFilter(inputImage, outputImage) {

            var table = null;
            if (imgType == 0)
                table = createFujiTable(0.6, 0.45, 0.45);
            else if (imgType == 1)
                table = createFujiTable(0.5, 0.5, 0.7);
            else if (imgType == 2)
                table = createFujiTable(0.6, 0.5, 0.45);
            else if (imgType == 3)
                table = createFujiTable(0.2, 0.4, 0.7);
            else if (imgType == 4)
                table = createFujiTable(0.8, 0.9, 1.0);
            else if (imgType == 5)
                table = createAcrosTable();
            else if (imgType == 6)
                table = createSepiaTable();
            else if (imgType == 7)
                table = createBrightnessContrastTable(0, 1.1);
            else if (imgType = 8)
                table = createGrayscaleTable(0, 20);

            var op = new java.awt.image.LookupOp(table, null);
            op.filter(inputImage, outputImage);

            return outputImage;
        }

        function createFujiTable(rl, gl, bl) {
            var rLUT = new Array(256);
            var gLUT = new Array(256);
            var bLUT = new Array(256);

            for (var i = 0; i < 256; i++) {
                rLUT[i] = curve(i, 255, rl);
                gLUT[i] = curve(i, 255, gl);
                bLUT[i] = curve(i, 255, bl);
            }

            var lutArrays = [rLUT, gLUT, bLUT];
            var lutLength = lutArrays[0].length;

            var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, lutArrays.length, lutLength);
            for (var i = 0; i < lutArrays.length; i++) {

                for (var j = 0; j < lutLength; j++) {
                    // convert unsigned int 0-255 to signed java byte
                    byteLookupArrays[i][j] = truncate(toSignedByte(lutArrays[i][j]));
                }
            }

            var table = new java.awt.image.ByteLookupTable(0, byteLookupArrays);

            return table;
        }

        function createGrayscaleTable(brightness, contrast) {
            // Clamp brightness and contrast values to valid ranges
            brightness = Math.max(Math.min(brightness, 100), -100);
            contrast = Math.max(Math.min(contrast, 100), -100);

            // Calculate contrast factor
            var contrastFactor = (259 * (contrast + 255)) / (255 * (259 - contrast));

            var lutArrays = [
                [],
                [],
                []
            ];
            for (var i = 0; i < 256; i++) {
                // Calculate grayscale value
                var gray = Math.round(contrastFactor * (i - 128) + 128 + brightness);
                gray = Math.max(Math.min(gray, 255), 0);

                // Populate lookup table arrays
                lutArrays[0][i] = gray;
                lutArrays[1][i] = gray;
                lutArrays[2][i] = gray;
            }

            // Create ByteLookupTable
            var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, lutArrays.length, 256);
            for (var i = 0; i < lutArrays.length; i++) {
                for (var j = 0; j < lutArrays[i].length; j++) {
                    byteLutArrays[i][j] = lutArrays[i][j];
                }
            }
            return new java.awt.image.ByteLookupTable(0, byteLutArrays);
        }

        // chatgpt brightness -255 to 255. contrast 0 to 1
        function createBrightnessContrastTable(brightness, contrast) {
            var lutLength = 256;
            //var byteLookupArrays = JSI.javaByteArray(1, lutLength);
            var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, 1, lutLength);
            for (var i = 0; i < lutLength; i++) {
                var val = ((i - 128) * contrast) + 128 + brightness;
                byteLookupArrays[0][i] = Math.max(0, Math.min(255, val));
            }

            return new java.awt.image.ByteLookupTable(0, byteLookupArrays);
        }

        function createAcrosTable() {
            var rLUT = new Array(256);
            var gLUT = new Array(256);
            var bLUT = new Array(256);

            for (var i = 0; i < 256; i++) {
                var r = i / 255;
                rLUT[i] = Math.min(255, Math.max(0, Math.round(255 * (1 - Math.pow(1 - r, 2.5)))));
                gLUT[i] = rLUT[i];
                bLUT[i] = rLUT[i];
            }

            var lutArrays = [rLUT, gLUT, bLUT];
            var lutLength = lutArrays[0].length; //256?

            var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, lutArrays.length, lutLength);
            for (var i = 0; i < lutArrays.length; i++) {
                for (var j = 0; j < lutLength; j++) {
                    byteLookupArrays[i][j] = truncate(toSignedByte(lutArrays[i][j] & 0xFF));
                }
            }
            var table = new java.awt.image.ByteLookupTable(0, byteLookupArrays);

            return table;
        }

        function createSepiaTable() {
            var rLUT = new Array(256);
            var gLUT = new Array(256);
            var bLUT = new Array(256);

            for (var i = 0; i < 256; i++) {
                var tr = Math.min(255, (i * 0.393) + (i * 0.769) + (i * 0.189));
                var tg = Math.min(255, (i * 0.349) + (i * 0.686) + (i * 0.168));
                var tb = Math.min(255, (i * 0.272) + (i * 0.534) + (i * 0.131));

                rLUT[i] = tr;
                gLUT[i] = tg;
                bLUT[i] = tb;
            }

            var lutArrays = [rLUT, gLUT, bLUT];
            var lutLength = lutArrays[0].length;

            var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, lutArrays.length, lutLength);
            for (var i = 0; i < lutArrays.length; i++) {
                for (var j = 0; j < lutLength; j++) {
                    byteLookupArrays[i][j] = truncate(toSignedByte(lutArrays[i][j]));
                }
            }

            var table = new java.awt.image.ByteLookupTable(0, byteLookupArrays);

            return table;
        }

        function truncate(number) {
            return number < 0 ? Math.ceil(number) : Math.floor(number);
        }

        function toSignedByte(value) {
            if (value > 127) {
                return -(256 - value);
            } else {
                return value;
            }
        }




        function curve(v, maxValue, strength) {
            var result = v / maxValue;

            result = Math.pow(result, 1 / strength);

            result = Math.floor(result * maxValue + 0.5);

            if (result < 0) {
                result = 0;
            }

            if (result > maxValue) {
                result = maxValue;
            }

            return result;
        }

        var painter = function(gfx, image, img, pp) {
            var r = pp.getImageRect(image);
            var bw = new java.awt.image.BufferedImage(r.width, r.height, image.getType());
            var aaImage = applyFujiFilter(image.getSubimage(r.x, r.y, r.width, r.height), bw);
            gfx.drawImage(aaImage, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);

        }

        return JSI.namedPainter(painter, cArray[imgType]);

    }


    addUserCommand('Velvia', function() {
        setPainter(new BufferedPainter(Film.getPainter(0)));
    }, 'Film');

    addUserCommand('Classic Negative', function() {
        setPainter(new BufferedPainter(Film.getPainter(1)));
    }, 'Film');

    addUserCommand('Eterna', function() {
        setPainter(new BufferedPainter(Film.getPainter(2)));
    }, 'Film');

    addUserCommand('Eterna Beach Bypass', function() {
        setPainter(new BufferedPainter(Film.getPainter(3)));
    }, 'Film');

    addUserCommand('Classic Chrome', function() {
        setPainter(new BufferedPainter(Film.getPainter(4)));
    }, 'Film');

    addUserCommand('Acros', function() {
        setPainter(new BufferedPainter(new ComboPainter(BW.getPainter(), Film.getPainter(5))));
    }, 'Film');

    addUserCommand('Sepia', function() {
        setPainter(new BufferedPainter(ComboPainter(BW.getPainter(), Film.getPainter(6))));
    }, 'Film');



})();
