// only works if JavaFX installed - must be added separately via modules in Java 11+

var Caman = new (function(){

	this.help = function(){
		showMessage('<html>Caman Filters<br>Filter images using JavaScript Caman image library. Requires JavaFX.<br><li>getPainter(name)');	
	}

	this.getPainter = function(label){
		if(lib == null){
			lib = readFromURL('http://www.metaloupe.com/js/caman.full.min.js');
		}

		// tell caman to do it's thing - you must call pg.done() to signal
		// photogrok to stop blocking and paint the image

		// you must also send something back in done - huge performance hit
		// if called without an argument
		var trigger = "Caman(\"#pgcanvas\", function () {\n" +
		"  this." + label + "();\n" +
		"  this.render(function () {\n" +
		"    pg.done('done');\n" +
		"  });\n" +
		"});\n";

		// create painter with auto-caching
		return new JSImagePainter(trigger, lib);
	}

	addUserCommand('caman', function(){
		Caman.help();
	}, 'Help');


	// list of available caman filters
	var camanFilters = ['vintage', 'lomo', 'clarity', 'sinCity', 'sunrise', 'crossProcess', 'orangePeel', 
		'love', 'grungy', 'jarques', 'pinhole', 'oldBoot', 'glowingSun', 'hazyDays', 'herMajesty',
		'nostalgia', 'hemingway', 'concentrate', ];


	var lib = null;

	for(var i = 0; i < camanFilters.length; i++){
		// add a user top-level menu for each filter
		addUserCommand(camanFilters[i], function(label){	
			// avoid a race condition in graal.js
			setPainter(null); 
			// load caman library from web
			if(lib == null){
				lib = readFromURL('http://www.metaloupe.com/js/caman.full.min.js');
			}
		
			// tell caman to do it's thing - you must call pg.done() to signal
			// photogrok to stop blocking and paint the image

			// you must also send something back in done - huge performance hit
			// if called without an argument
			var trigger = "Caman(\"#pgcanvas\", function () {\n" +
			"  this." + label + "();\n" +
			"  this.render(function () {\n" +
			"    pg.done('done');\n" +
			"  });\n" +
			"});\n";
		
			// create painter with auto-caching
			var r = new JSImagePainter(trigger, lib);

			setPainter(r);
		}, "Caman Filters");
	}
})();
