var Anim = new(function() {
    this.help = function() {
        showMessage('<html>Anim<br>Demo of Timer fuctionality using animations. Toggle from "User" menu or use shortcut keys (see menu items).');
    }

    function rand(min, max) { // min and max included 
        return Math.floor(Math.random() * (max - min + 1) + min)
    }

    function doSave(p) {

        if (p == null) {

            p = JSI.getPainter();
            filler = p != null && p.getName().indexOf('Filler') != -1;
            if (p == null || filler) {

                p = function(gfx, i1, i2, pp) {}
            }
        }
        return p;

    }

    function cancelCheck(c) {
        if (c) {
            cancel = true;
            task.cancel();
            if (filler) Filler.on();
            else setPainter(save);
            runningTask = null;
            save = null;
        }
        return c;
    }

    addUserCommand('anim', function() {
        Anim.help();
    }, 'Help');

    var cancel = true;
    var filler = false;
    var timer = new Timer();
    var task = null;
    var runningTask = null;

    var save = null;


    var runWatero = function() {
        if (runningTask != null && runningTask !== 'water') {
            // something else running
            task.cancel();
            cancel = true;
        }
        cancel = !cancel;

        if (cancelCheck(cancel)) return;

        runningTask = 'water';
        var x = 3;
        var up = true;

        save = doSave(save);

        var amp = rand(5, 100);

        var watero = function() {
            if (save != null)
                setPainter(new ComboPainter(save, JHLabs.getPainter('Water:radius=' + x + ':amplitude=' + amp + ':wavelength=10')));
            else
                setPainter(JHLabs.getPainter('Water:radius=' + x + ':amplitude=' + amp + ':wavelength=10'));


            if (up) {
                x++;
                if (x > 300) {
                    up = false;
                }
            } else {
                x--;
                if (x < 3) {
                    up = true;
                }

            }
        }

        task = timer.schedule(watero, 100, 100);
    }



    var runKaleido = function() {
        if (runningTask != null && runningTask !== 'kaleido') {
            // something else running
            task.cancel();
            cancel = true;
        }
        cancel = !cancel;
        if (cancelCheck(cancel)) return;

        runningTask = 'kaleido';
        var x = 0;
        var up = true;

        save = doSave(save);

        var kaleido = function() {
            if (save != null)
                setPainter(new ComboPainter(save, JHLabs.getPainter('Kaleidoscope:sides=' + x)));
            else
                setPainter(JHLabs.getPainter('Kaleidoscope:sides=' + x));

            if (up) {
                x++;
                if (x > 100) {
                    up = false;
                }
            } else {
                x--;
                if (x < 1) {
                    up = true;
                }

            }

        }

        task = timer.schedule(kaleido, 100, 100);
    }

    var runSquinto = function() {
        if (runningTask != null && runningTask !== 'squinto') {
            // something else running
            task.cancel();
            cancel = true;
        }
        cancel = !cancel;
        if (cancelCheck(cancel)) return;

        runningTask = 'squinto';
        var x = 2;
        var up = true;

        save = doSave(save);

        var squinto = function() {
            if (save != null)
                setPainter(new ComboPainter(save, Squint.getPainter('Monospaced', x)));
            else
                setPainter(Squint.getPainter('Monospaced', x));

            if (up) {
                x++;
                if (x > 20) {
                    up = false;
                }
            } else {
                x--;
                if (x < 2) {
                    up = true;
                }

            }

        }

        task = timer.schedule(squinto, 100, 100);

    }


    var runTrip = function() {
        if (runningTask != null && runningTask !== 'trip') {
            // something else running
            task.cancel();
            cancel = true;
        }
        cancel = !cancel;
        if (cancelCheck(cancel)) return;

        runningTask = 'trip';
        var x = 0;
        var up = true;

        save = doSave(save);
        var initSides = rand(10, 150);
        var tripo = function() {
            if (save != null)
                setPainter(new ComboPainter(save, new ComboPainter(JHLabs.getPainter('Kaleidoscope:sides=' + initSides), JHLabs.getPainter('Kaleidoscope:sides=' + x))));
            else
                setPainter(new ComboPainter(JHLabs.getPainter('Kaleidoscope:sides=100'), JHLabs.getPainter('Kaleidoscope:sides=' + x)));

            if (up) {
                x++;
                if (x > 30) {
                    up = false;
                }
            } else {
                x--;
                if (x < 1) {
                    up = true;
                }

            }

        }

        task = timer.schedule(tripo, 100, 100);
    }

    var runPool = function() {
        if (runningTask != null && runningTask !== 'pool') {
            // something else running
            task.cancel();
            cancel = true;
        }
        cancel = !cancel;
        if (cancelCheck(cancel)) return;

        runningTask = 'pool';
        var x = 0.0

        save = doSave(save);
        var initSides = rand(10, 150);
        var poolParty = function() {

            setPainter(JHLabs.getPainter('Caustics:time=' + x + ':amount=.5:scale=100:samples=1'));
            x += .125; // this numer is tricky - a lot of values don't make the translation to float when calling java method

        }

        task = timer.schedule(poolParty, 100, 100);
    }

    addUserCommand('Kaleido CTRL+SHIFT+K', runKaleido, 'Anim');
    addUserCommand('Squinto CTRL+SHIFT+P', runSquinto, 'Anim');
    addUserCommand('Water CTRL+SHIFT+W', runWatero, 'Anim');
    addUserCommand('Trip CTRL+SHIFT+Y', runTrip, 'Anim');
    addUserCommand('Pool CTRL+SHIFT+P', runPool, 'Anim');

    // add a shortcut key - see Java's KeyEvent and InputEvent documentation
    JSI.addShortcut(runKaleido, java.awt.event.KeyEvent.VK_K, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addFullScreenShortcut(runKaleido, java.awt.event.KeyEvent.VK_K, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addShortcut(runSquinto, java.awt.event.KeyEvent.VK_U, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addFullScreenShortcut(runSquinto, java.awt.event.KeyEvent.VK_U, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addShortcut(runWatero, java.awt.event.KeyEvent.VK_W, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addFullScreenShortcut(runWatero, java.awt.event.KeyEvent.VK_W, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addShortcut(runTrip, java.awt.event.KeyEvent.VK_Y, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addFullScreenShortcut(runTrip, java.awt.event.KeyEvent.VK_Y, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addShortcut(runPool, java.awt.event.KeyEvent.VK_P, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
    JSI.addFullScreenShortcut(runPool, java.awt.event.KeyEvent.VK_P, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);



})();
