/*
 * Decompiled with CFR 0.152.
 */
package swingtask;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BusyIndicator
extends JComponent
implements ActionListener {
    private boolean mIsRunning;
    private boolean mIsFadingOut;
    private Timer mTimer;
    private int mAngle;
    private int mFadeCount;
    private int mFadeLimit = 15;

    public void paint(Graphics graphics) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (!this.mIsRunning) {
            return;
        }
        graphics = (Graphics2D)graphics.create();
        float f2 = (float)this.mFadeCount / (float)this.mFadeLimit;
        int n4 = Math.min(n2, n3) / 5;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setStroke(new BasicStroke(n4 / 4, 1, 1));
        ((Graphics2D)graphics).setPaint(Color.white);
        ((Graphics2D)graphics).rotate(Math.PI * (double)this.mAngle / 180.0, n2 /= 2, n3 /= 2);
        for (int i2 = 0; i2 < 12; ++i2) {
            float f3 = (11.0f - (float)i2) / 11.0f;
            graphics.drawLine(n2 + n4, n3, n2 + (n4 << 1), n3);
            ((Graphics2D)graphics).rotate(-0.5235987755982988, n2, n3);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, f3 * f2));
        }
        graphics.dispose();
    }

    public final void a() {
        if (this.mIsRunning) {
            if (this.mIsFadingOut) {
                this.mIsFadingOut = false;
            }
            return;
        }
        this.mIsRunning = true;
        this.mIsFadingOut = false;
        this.mFadeCount = 0;
        this.mTimer = new Timer(33, this);
        this.mTimer.start();
    }

    public final void b() {
        this.mIsFadingOut = true;
    }

    public final boolean a() {
        if (this.mTimer != null) {
            return this.mTimer.isRunning();
        }
        return false;
    }

    public void setVisible(boolean bl2) {
        if (!bl2 && this.a()) {
            this.mFadeCount = 0;
            this.mIsRunning = false;
            this.mTimer.stop();
        }
        super.setVisible(bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mIsRunning) {
            this.repaint();
            this.mAngle += 3;
            if (this.mAngle >= 360) {
                this.mAngle = 0;
            }
            if (this.mIsFadingOut) {
                if (--this.mFadeCount == 0) {
                    this.mIsRunning = false;
                    this.mTimer.stop();
                    return;
                }
            } else if (this.mFadeCount < this.mFadeLimit) {
                ++this.mFadeCount;
            }
        }
    }
}

