/*
 * Decompiled with CFR 0.152.
 */
package photogrok;

import com.mortennobel.imagescaling.ResampleOp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import photogrok.AppPrefs;
import photogrok.ExifPane;
import photogrok.I;
import photogrok.Painter;
import photogrok.PainterProps;
import photogrok.PhotoGrok;
import photogrok.W;
import photogrok.X;
import photogrok.Z;
import photogrok.aL;
import photogrok.aa;
import photogrok.ac;
import photogrok.ad;
import photogrok.bK;
import photogrok.ce;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ImagePanel
extends JComponent
implements ComponentListener {
    private boolean slideShow;
    private Color slideShowBackground = Color.BLACK;
    private double scale;
    private double saveScale;
    private boolean maxScale;
    private Point startDragPoint = new Point(0, 0);
    private Point endDragPoint = new Point(0, 0);
    private int xOff = 0;
    private int yOff = 0;
    private int imageX;
    private int imageY;
    private boolean dragging;
    private boolean zooming;
    private double percentX;
    private double percentY;
    private Point lastMousePoint;
    private Rectangle imageBounds = new Rectangle();
    private int locX;
    private int locY;
    private int initImageX;
    private int initImageY;
    private int initImageY2;
    private int initImageX2;
    private Dimension compSize = new Dimension();
    private Insets myInsets = new Insets(0, 0, 0, 0);
    private Painter painter;
    private long lastResize;
    private long lastMagnify;
    private Timer timer;
    private Timer timer1;
    private boolean resizing;
    private BufferedImage origScaledImage;
    private BufferedImage scaledImage;
    private Dimension saveSize = new Dimension();
    private ArrayList<String> tags = new ArrayList();
    private BufferedImage image;
    private static ImagePanel a;
    private boolean showMessage;
    private bK tagData;
    private Color txtBoxColor;
    int scaledWidth = 0;
    int scaledHeight = 0;

    public ImagePanel(boolean bl2, boolean bl3) {
        this.slideShow = bl2;
        this.setOpaque(false);
        if (!bl2) {
            String[] stringArray = UIManager.getColor("Panel.background");
            this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Panel.background").darker()));
            this.txtBoxColor = new Color(stringArray.getRed(), stringArray.getGreen(), stringArray.getBlue(), 200);
            stringArray = AppPrefs.a().a();
            if (stringArray.indexOf(44) != -1) {
                for (String string : ce.a((String)stringArray, ',')) {
                    this.tags.add(string.trim());
                }
            } else if (stringArray.trim().length() > 0) {
                this.tags.add(stringArray.trim());
            }
        }
        if (bl3) {
            this.addMouseMotionListener(new W(this));
            this.addMouseWheelListener(new X(this));
            this.addMouseListener(new Z(this, bl2));
        }
    }

    public final void a() {
        this.a(this.locX, this.locY);
    }

    public final void b() {
        Object object = new PainterProps();
        ((PainterProps)object).a(this.imageX, this.imageY, this.compSize.width, this.compSize.height, this.slideShow, false, false, false, null, null, this.scaledWidth, this.scaledHeight);
        object = ((PainterProps)object).getImageRect(this.scaledImage);
        BufferedImage bufferedImage = this.scaledImage.getSubimage(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        if (this.painter != null) {
            PainterProps painterProps = new PainterProps();
            painterProps.a(0, 0, ((Rectangle)object).width, ((Rectangle)object).height, this.slideShow, false, false, false, null, null, ((Rectangle)object).width, ((Rectangle)object).height);
            if (PhotoGrok.a instanceof I) {
                object = aL.a;
                synchronized (object) {
                    this.painter.paint((Graphics2D)bufferedImage.getGraphics(), bufferedImage, bufferedImage, painterProps);
                }
            } else {
                this.painter.paint((Graphics2D)bufferedImage.getGraphics(), bufferedImage, bufferedImage, painterProps);
            }
        }
        ce.a(this.tagData, bufferedImage);
    }

    private void a(int n2, int n3) {
        if (!this.imageBounds.contains(n2, n3)) {
            return;
        }
        if (this.maxScale) {
            this.scale = 1.0;
            this.maxScale = false;
            this.repaint();
            return;
        }
        Insets insets = this.getInsets(this.myInsets);
        n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        double d2 = (double)n3 / (double)n4;
        int n5 = this.compSize.width - insets.left - insets.right;
        int n6 = this.compSize.height - insets.top - insets.bottom;
        do {
            this.scale += 0.1;
            this.scaledWidth = n5;
            this.scaledHeight = (int)((double)n5 / d2);
            if (this.scaledHeight > n6) {
                this.scaledHeight = n6;
                this.scaledWidth = (int)((double)n6 * d2);
            }
            this.scaledWidth = (int)((double)this.scaledWidth * this.scale);
            this.scaledHeight = (int)((double)this.scaledHeight * this.scale);
        } while (this.scaledWidth <= n3 && this.scaledHeight <= n4);
        this.maxScale = true;
        this.scaledWidth = n3;
        this.scaledHeight = n4;
        this.repaint();
    }

    public final void a(BufferedImage bufferedImage, boolean bl2, boolean bl3, bK bK2) {
        this.image = bufferedImage;
        this.scale = 1.0;
        this.saveScale = 1.0;
        this.dragging = false;
        this.zooming = false;
        this.resizing = false;
        this.lastMousePoint = null;
        this.xOff = 0;
        this.yOff = 0;
        this.origScaledImage = null;
        this.scaledImage = null;
        this.tagData = bK2;
        this.showMessage = bl2;
        if (bl3) {
            this.repaint();
        }
        this.a("onImageChanged");
    }

    private void a(String string) {
        if (this.tagData != null) {
            EventQueue.invokeLater(new aa(this, string));
        }
    }

    public final void c() {
        this.painter = null;
    }

    public final void a(Painter painter) {
        EventQueue.invokeLater(new ac(this, painter));
    }

    public final Painter a() {
        return this.painter;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n2 = 0;
        this.compSize.setSize(this.getWidth(), this.getHeight());
        if (this.slideShow) {
            graphics.setColor(this.slideShowBackground);
            graphics.fillRect(0, 0, this.compSize.width, this.compSize.height);
        }
        if (this.image != null || this.scaledImage != null) {
            int n3;
            int n4;
            int n5;
            if (!this.dragging && (this.zooming || this.resizing || this.scaledImage == null || !this.saveSize.equals(this.compSize) || this.saveScale != this.scale)) {
                this.resizing = false;
                this.saveSize.setSize(this.compSize);
                this.saveScale = this.scale;
                Insets insets = this.getInsets(this.myInsets);
                n5 = this.image.getWidth();
                n4 = this.image.getHeight();
                double d2 = (double)n5 / (double)n4;
                n3 = this.compSize.width - insets.left - insets.right;
                int n6 = this.compSize.height - insets.top - insets.bottom;
                this.scaledWidth = n3;
                this.scaledHeight = (int)((double)n3 / d2);
                if (this.scaledHeight > n6) {
                    this.scaledHeight = n6;
                    this.scaledWidth = (int)((double)n6 * d2);
                }
                if (this.scaledWidth > n5 || this.scaledHeight > n4) {
                    this.scaledWidth = n5;
                    this.scaledHeight = n4;
                    this.scaledImage = this.image;
                } else {
                    if (this.scaledHeight <= 0) {
                        this.scaledHeight = 1;
                    }
                    if (this.scaledWidth <= 0) {
                        this.scaledWidth = 1;
                    }
                    if (System.currentTimeMillis() - this.lastResize < 500L) {
                        this.scaledImage = ImagePanel.a(this.image, this.scaledWidth, this.scaledHeight, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, false, false);
                        n2 = 1;
                    } else {
                        n2 = 0;
                        this.scaledWidth = (int)((double)this.scaledWidth * this.scale);
                        this.scaledHeight = (int)((double)this.scaledHeight * this.scale);
                        if (this.scaledWidth > n5 || this.scaledHeight > n4) {
                            this.maxScale = true;
                            this.scaledWidth = n5;
                            this.scaledHeight = n4;
                            this.scaledImage = this.image;
                        } else if (this.zooming) {
                            this.scaledImage = ImagePanel.a(this.image, this.scaledWidth, this.scaledHeight, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, false, false);
                        } else {
                            ResampleOp resampleOp = new ResampleOp(this.scaledWidth, this.scaledHeight);
                            this.scaledImage = resampleOp.filter(this.image, null);
                        }
                    }
                }
                if (this.lastMousePoint != null && this.scale != 1.0) {
                    n5 = (int)((double)this.scaledWidth * this.percentX);
                    n4 = (int)((double)this.scaledHeight * this.percentY);
                    this.imageX = this.lastMousePoint.x - n5;
                    this.imageY = this.lastMousePoint.y - n4;
                    if (this.scaledWidth >= this.scaledHeight) {
                        if (this.imageX > this.initImageX) {
                            this.imageX = this.initImageX;
                        } else if (this.imageX + this.scaledWidth < this.initImageX2) {
                            this.imageX = this.initImageX2 - this.scaledWidth;
                        }
                        if (this.imageY > this.initImageY) {
                            this.imageY = this.initImageY;
                        } else if (this.imageY + this.scaledHeight < this.initImageY2) {
                            this.imageY = this.initImageY2 - this.scaledHeight;
                        }
                    } else {
                        if (this.imageY > this.initImageY) {
                            this.imageY = this.initImageY;
                        } else if (this.imageY + this.scaledHeight < this.initImageY2) {
                            this.imageY = this.initImageY2 - this.scaledHeight;
                        }
                        if (this.imageX > this.initImageX) {
                            this.imageX = this.initImageX;
                        } else if (this.imageX + this.scaledWidth < this.initImageX2) {
                            this.imageX = this.initImageX2 - this.scaledWidth;
                        }
                    }
                } else {
                    this.initImageX = this.imageX = this.compSize.width / 2 - this.scaledWidth / 2;
                    this.initImageX2 = this.initImageX + this.scaledWidth;
                    this.initImageY = this.imageY = this.compSize.height / 2 - this.scaledHeight / 2;
                    this.initImageY2 = this.initImageY + this.scaledHeight;
                }
            }
            if (this.dragging) {
                Insets insets = this.getInsets(this.myInsets);
                n5 = this.compSize.width - insets.left - insets.right;
                n4 = this.compSize.height - insets.top - insets.bottom;
                this.xOff = this.startDragPoint.x - this.endDragPoint.x;
                this.yOff = this.startDragPoint.y - this.endDragPoint.y;
                this.startDragPoint.setLocation(this.endDragPoint.x, this.endDragPoint.y);
                int n7 = this.imageX - this.xOff;
                this.imageX = n7 < 0 ? (this.scaledWidth <= n5 ? 0 : (n7 + this.scaledWidth < n5 ? n5 - this.scaledWidth : n7)) : (n7 > 0 && n7 + this.scaledWidth > n5 ? (this.scaledWidth <= n5 ? n5 - this.scaledWidth : 0) : n7);
                int n8 = this.imageY - this.yOff;
                this.imageY = n8 < 0 ? (this.scaledHeight <= n4 ? 0 : (n8 + this.scaledHeight < n4 ? n4 - this.scaledHeight : n8)) : (n8 > 0 && n8 + this.scaledHeight > n4 ? (this.scaledHeight <= n4 ? n4 - this.scaledHeight : 0) : n8);
            }
            graphics.drawImage(this.scaledImage, this.imageX, this.imageY, this.scaledWidth, this.scaledHeight, null);
            if (this.painter != null && this.image != null) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                Color color = graphics.getColor();
                PainterProps painterProps = new PainterProps();
                if (this.tagData != null) {
                    painterProps.a(this.imageX, this.imageY, this.compSize.width, this.compSize.height, this.slideShow, this.dragging, this.zooming, n2 != 0, this.tagData.c, this.tagData.d, this.scaledWidth, this.scaledHeight);
                } else {
                    painterProps.a(this.imageX, this.imageY, this.compSize.width, this.compSize.height, this.slideShow, this.dragging, this.zooming, n2 != 0, null, null, this.scaledWidth, this.scaledHeight);
                }
                if (PhotoGrok.a instanceof I) {
                    Object object = aL.a;
                    synchronized (object) {
                        this.painter.paint((Graphics2D)graphics, this.scaledImage, this.image, painterProps);
                    }
                } else {
                    this.painter.paint((Graphics2D)graphics, this.scaledImage, this.image, painterProps);
                }
                graphics.setColor(color);
            }
            if (!this.slideShow && this.tags.size() > 0) {
                Serializable serializable = ExifPane.a().a((ArrayList)this.tags.clone());
                Object object = new StringBuilder();
                n4 = 0;
                for (String string : serializable) {
                    ((StringBuilder)object).append(string);
                    if (++n4 >= serializable.size()) continue;
                    ((StringBuilder)object).append("     ");
                }
                int n9 = graphics.getFontMetrics().getHeight();
                String string = ((StringBuilder)object).toString();
                n3 = (this.compSize.height - this.scaledHeight - (this.compSize.height / 2 - this.scaledHeight / 2)) / 2 - n9 / 2;
                if (n3 < n9 / 2) {
                    n3 = n9 / 2;
                }
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                serializable = graphics.getColor();
                graphics.setColor(this.txtBoxColor);
                object = graphics.getFontMetrics().getStringBounds(string, graphics);
                n4 = (int)((double)(this.compSize.width / 2) - ((RectangularShape)object).getWidth() / 2.0);
                n2 = this.compSize.height - n3;
                graphics.fillRect(n4 - 5, n2 + graphics.getFontMetrics().getDescent() - n9, (int)((RectangularShape)object).getWidth() + 10, n9 + graphics.getFontMetrics().getDescent());
                graphics.setColor((Color)serializable);
                graphics.drawString(string, n4, n2);
                return;
            }
        } else if (this.showMessage) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            graphics.setColor(Color.BLACK);
            String string = "Image Not Found: " + this.tagData.c;
            graphics.drawString(string, (int)((double)(this.compSize.width / 2) - graphics.getFontMetrics().getStringBounds(string, graphics).getWidth() / 2.0), this.compSize.height / 2);
        }
    }

    public static BufferedImage a(BufferedImage bufferedImage, int n2, int n3, Object object, boolean bl2, boolean bl3) {
        int n4;
        int n5;
        int n6 = bufferedImage.getTransparency() == 1 && !bl3 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl2) {
            n5 = bufferedImage.getWidth();
            n4 = bufferedImage.getHeight();
        } else {
            n5 = n2;
            n4 = n3;
        }
        do {
            if (bl2 && n5 > n2 && (n5 /= 2) < n2) {
                n5 = n2;
            }
            if (bl2 && n4 > n3 && (n4 /= 2) < n3) {
                n4 = n3;
            }
            BufferedImage bufferedImage3 = new BufferedImage(n5, n4, n6);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage2, 0, 0, n5, n4, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n5 != n2 || n4 != n3);
        return bufferedImage2;
    }

    public final bK a() {
        return this.tagData;
    }

    public static synchronized ImagePanel a() {
        if (a == null) {
            a = new ImagePanel(false, true);
            a.addComponentListener(a);
        }
        return a;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.scale = 1.0;
        this.saveScale = 1.0;
        this.dragging = false;
        this.zooming = false;
        this.lastMousePoint = null;
        this.xOff = 0;
        this.yOff = 0;
        if (this.timer == null) {
            this.timer = new Timer(1000, new ad(this));
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
        this.lastResize = System.currentTimeMillis();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public final BufferedImage a() {
        if (this.scaledImage == null) {
            return null;
        }
        if (this.origScaledImage == null || this.origScaledImage.getWidth() != this.scaledImage.getWidth()) {
            this.origScaledImage = this.scaledImage;
        }
        BufferedImage bufferedImage = new BufferedImage(this.origScaledImage.getWidth(), this.origScaledImage.getHeight(), this.origScaledImage.getType());
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.origScaledImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    public final Map a() {
        if (this.scaledImage == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Serializable serializable = this;
        int n2 = serializable.imageX > 0 ? 0 : Math.abs(serializable.imageX);
        int n3 = serializable.imageY > 0 ? 0 : Math.abs(serializable.imageY);
        serializable = new Point(n2, n3);
        hashMap.put("offsetX", ((Point)serializable).x);
        hashMap.put("offsetY", ((Point)serializable).y);
        serializable = this;
        Rectangle rectangle = new Rectangle();
        n3 = 0;
        int n4 = 0;
        int n5 = serializable.scaledImage.getWidth();
        int n6 = serializable.scaledImage.getHeight();
        if (serializable.imageX < 0) {
            n5 = serializable.compSize.width;
            n3 = Math.abs(serializable.imageX);
        } else {
            n5 -= Math.min(serializable.imageX, 0);
        }
        if (serializable.imageY < 0) {
            n6 = serializable.compSize.height;
            n4 = Math.abs(serializable.imageY);
        } else {
            n6 -= Math.min(serializable.imageY, 0);
        }
        if (n4 + n6 > serializable.scaledImage.getHeight()) {
            n6 = serializable.scaledImage.getHeight() - n4;
        }
        if (n3 + n5 > serializable.scaledImage.getWidth()) {
            n5 = serializable.scaledImage.getWidth() - n3;
        }
        rectangle.setBounds(n3, n4, n5, n6);
        hashMap.put("visibleRect", rectangle);
        hashMap.put("name", this.tagData.c);
        hashMap.put("directory", this.tagData.d);
        return hashMap;
    }

    public final void a(BufferedImage bufferedImage) {
        this.scaledImage = bufferedImage;
        this.repaint();
    }

    static /* synthetic */ double a(ImagePanel imagePanel) {
        return imagePanel.scale;
    }

    static /* synthetic */ boolean a(ImagePanel imagePanel) {
        return imagePanel.dragging;
    }

    static /* synthetic */ boolean b(ImagePanel imagePanel) {
        return imagePanel.zooming;
    }

    static /* synthetic */ boolean a(ImagePanel imagePanel, boolean bl2) {
        imagePanel.zooming = bl2;
        return imagePanel.zooming;
    }

    static /* synthetic */ boolean b(ImagePanel imagePanel, boolean bl2) {
        imagePanel.dragging = bl2;
        return imagePanel.dragging;
    }

    static /* synthetic */ Point a(ImagePanel imagePanel) {
        return imagePanel.startDragPoint;
    }

    static /* synthetic */ Point b(ImagePanel imagePanel) {
        return imagePanel.endDragPoint;
    }

    static /* synthetic */ int a(ImagePanel imagePanel, int n2) {
        imagePanel.locX = n2;
        return imagePanel.locX;
    }

    static /* synthetic */ int b(ImagePanel imagePanel, int n2) {
        imagePanel.locY = n2;
        return imagePanel.locY;
    }

    static /* synthetic */ int a(ImagePanel imagePanel) {
        return imagePanel.imageX;
    }

    static /* synthetic */ int b(ImagePanel imagePanel) {
        return imagePanel.imageY;
    }

    static /* synthetic */ Rectangle a(ImagePanel imagePanel) {
        return imagePanel.imageBounds;
    }

    static /* synthetic */ int c(ImagePanel imagePanel) {
        return imagePanel.locX;
    }

    static /* synthetic */ int d(ImagePanel imagePanel) {
        return imagePanel.locY;
    }

    static /* synthetic */ double a(ImagePanel imagePanel, double d2) {
        imagePanel.percentX = d2;
        return imagePanel.percentX;
    }

    static /* synthetic */ double b(ImagePanel imagePanel, double d2) {
        imagePanel.percentY = d2;
        return imagePanel.percentY;
    }

    static /* synthetic */ Point c(ImagePanel imagePanel) {
        return imagePanel.lastMousePoint;
    }

    static /* synthetic */ Point a(ImagePanel imagePanel, Point point) {
        imagePanel.lastMousePoint = point;
        return imagePanel.lastMousePoint;
    }

    static /* synthetic */ boolean c(ImagePanel imagePanel) {
        return imagePanel.maxScale;
    }

    static /* synthetic */ boolean d(ImagePanel imagePanel) {
        imagePanel.maxScale = false;
        return false;
    }

    static /* synthetic */ Timer a(ImagePanel imagePanel) {
        return imagePanel.timer1;
    }

    static /* synthetic */ Timer a(ImagePanel imagePanel, Timer timer) {
        imagePanel.timer1 = timer;
        return imagePanel.timer1;
    }

    static /* synthetic */ long a(ImagePanel imagePanel) {
        return imagePanel.lastMagnify;
    }

    static /* synthetic */ boolean e(ImagePanel imagePanel) {
        imagePanel.resizing = true;
        return true;
    }

    static /* synthetic */ void a(ImagePanel imagePanel, String string) {
        imagePanel.a(string);
    }

    static /* synthetic */ long a(ImagePanel imagePanel, long l2) {
        imagePanel.lastMagnify = l2;
        return imagePanel.lastMagnify;
    }

    static /* synthetic */ double c(ImagePanel imagePanel, double d2) {
        return imagePanel.scale -= d2;
    }

    static /* synthetic */ double d(ImagePanel imagePanel, double d2) {
        imagePanel.scale = d2;
        return imagePanel.scale;
    }

    static /* synthetic */ void a(ImagePanel imagePanel, int n2, int n3) {
        imagePanel.a(n2, n3);
    }

    static /* synthetic */ boolean f(ImagePanel imagePanel) {
        return imagePanel.slideShow;
    }

    static /* synthetic */ bK a(ImagePanel imagePanel) {
        return imagePanel.tagData;
    }

    static /* synthetic */ int e(ImagePanel imagePanel) {
        imagePanel.xOff = 0;
        return 0;
    }

    static /* synthetic */ int f(ImagePanel imagePanel) {
        imagePanel.yOff = 0;
        return 0;
    }

    static /* synthetic */ Painter a(ImagePanel imagePanel, Painter painter) {
        imagePanel.painter = painter;
        return imagePanel.painter;
    }

    static /* synthetic */ long b(ImagePanel imagePanel) {
        return imagePanel.lastResize;
    }

    static /* synthetic */ Timer b(ImagePanel imagePanel) {
        return imagePanel.timer;
    }

    static /* synthetic */ ArrayList a(ImagePanel imagePanel) {
        return imagePanel.tags;
    }
}

